#include <ansi_c.h>
#include <cvirte.h>     
#include <userint.h>
#include "HB626.h"
#include "HB626_DLL.h"
#include "toolbox.h"

static int panelHandle;

unsigned char Fn_Num, Fn_Setting;
unsigned int Time1, Time2;
double dTime1, dTime2;

int main (int argc, char *argv[])
{
    int error = 0;
    
    Load_HB626();
    
    /* initialize and load resources */
    nullChk (InitCVIRTE (0, argv, 0));
    errChk (panelHandle = LoadPanel (0, "HB626.uir", PANEL));
    
    /* display the panel and run the user interface */
    errChk (DisplayPanel (panelHandle));
    errChk (RunUserInterface ());

Error:
    /* clean up */
    DiscardPanel (panelHandle);
    return 0;
}


int CVICALLBACK panelCB (int panel, int event, void *callbackData,
        int eventData1, int eventData2)
{
    if (event == EVENT_CLOSE)
        QuitUserInterface (0);
    return 0;
}

int CVICALLBACK Quit (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:
        QuitUserInterface (0);
      break;
  }
  return 0;
}

int CVICALLBACK Time_Calc (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{

  unsigned char Day, Hour, Min, Sec;
  unsigned int Time_Result;
  
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panelHandle, PANEL_NUMERIC_DAY, ATTR_CTRL_VAL, &Day);
      GetCtrlAttribute (panelHandle, PANEL_NUMERIC_HOUR, ATTR_CTRL_VAL, &Hour);
      GetCtrlAttribute (panelHandle, PANEL_NUMERIC_MINUTE, ATTR_CTRL_VAL, &Min);
      GetCtrlAttribute (panelHandle, PANEL_NUMERIC_SECOND, ATTR_CTRL_VAL, &Sec);
      
      Time_Result = Day*24*60*60 + Hour*60*60 + Min*60 + Sec;
      
      
      SetCtrlAttribute (panelHandle, PANEL_NUMERIC_TIME_RESULT, ATTR_CTRL_VAL, Time_Result);

      break;
  }
  return 0;
}


int Send_Cfg(void)
{

  if( !HB626_Open() )
  {
    MessagePopup("Fehler", "Das Geraet wurde nicht gefunden!");
    return 0;
  }
   
  if( !HB626_Send_Cfg( Fn_Num, Fn_Setting, Time1, Time2 ) )
  {
    MessagePopup("Fehler", "Sendefehler!");
    return 0;
  }

  if( !HB626_Get_Reply() )
  {
    MessagePopup("Fehler", "Empfangsfehler!");
    return 0;
  }
   
  HB626_Close();
   
  MessagePopup("Info", "Die Einstellungen wurden abgeschickt!");
  return 1;

}

int Send_Cfg_F9(void)
{

  if( !HB626_Send_Cfg( Fn_Num, Fn_Setting, Time1, Time2 ) )
  {
    MessagePopup("Fehler", "Sendefehler!");
    return 0;
  }

  if( !HB626_Get_Reply() )
  {
    MessagePopup("Fehler", "Empfangsfehler!");
    return 0;
  }
  
  return 1;

}

int CVICALLBACK Send_F1 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN1_NUMERIC_T1_F1, ATTR_CTRL_VAL, &dTime1);
      
      Fn_Num = 1;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F2 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN2_NUMERIC_T1_F2, ATTR_CTRL_VAL, &dTime1);
      
      Fn_Num = 2;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F3 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN3_NUMERIC_T1_F3, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN3_NUMERIC_T2_F3, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 3;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F4 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN4_NUMERIC_T1_F4, ATTR_CTRL_VAL, &dTime1);
      
      Fn_Num = 4;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F5 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN5_NUMERIC_T1_F5, ATTR_CTRL_VAL, &dTime1);
      
      Fn_Num = 5;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F6 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      Fn_Num = 6;
      Fn_Setting = 0;
      Time1 = 0;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F7 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      Fn_Num = 7;
      Fn_Setting = 0;
      Time1 = 0;
      Time2 = 0;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F8 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{
  switch (event)
  {
    case EVENT_COMMIT:

      GetCtrlAttribute (panel, TAB_FN8_NUMERIC_T1_F8, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN8_NUMERIC_T2_F8, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 8;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      Send_Cfg();
      
      break;
  }
  return 0;
}

int CVICALLBACK Send_F9 (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2)
{

  int AutoRestart;
  
  switch (event)
  {
    case EVENT_COMMIT:
      
      if( !HB626_Open() )
      {
        MessagePopup("Fehler", "Das Geraet wurde nicht gefunden!");
        return 1;
      }
       
      //Channel 1
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T1_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T1_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 91;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 2
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T2_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T2_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 92;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 3
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T3_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T3_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 93;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 4
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T4_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T4_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 94;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 5
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T5_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T5_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 95;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 6
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T6_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T6_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 96;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 7
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T7_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T7_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 97;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //Channel 8
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T8_START_F9, ATTR_CTRL_VAL, &dTime1);
      GetCtrlAttribute (panel, TAB_FN9_NUMERIC_T8_STOP_F9, ATTR_CTRL_VAL, &dTime2);
      
      Fn_Num = 98;
      Fn_Setting = 0;
      Time1 = dTime1*1000;
      Time2 = dTime2*1000;
      
      if( !Send_Cfg_F9() )
        return 1;
      
      //fn9 cfg
      GetCtrlAttribute (panel, TAB_FN9_AUTORESTART_F9, ATTR_CTRL_VAL, &AutoRestart);

      Fn_Num = 9;
      
      if( AutoRestart )
        Fn_Setting = 1;
      else
        Fn_Setting = 0;
      
      Time1 = 0;
      Time2 = 0;
      
      if( !Send_Cfg_F9() )
        return 1;

      HB626_Close();
   
      MessagePopup("Info", "Die Einstellungen wurden abgeschickt!");
      
      
      break;
  }
  return 0;
}

