#include <ansi_c.h>
#include "HB626_DLL.h"

HB626_OPEN HB626_Open;
HB626_CLOSE HB626_Close;
HB626_SEND_CFG HB626_Send_Cfg;
HB626_GET_REPLY HB626_Get_Reply;

// handle to DLL...
HANDLE HB626_Handle;

// Release the DLL from memory...
void Unload_HB626(void)
{
   FreeLibrary(HB626_Handle);
}

// load the DLL into memory...
int Load_HB626(void)
{

  // load DLL, exit if not found...
  HB626_Handle = LoadLibrary("hb626.dll");
  if (HB626_Handle == NULL) return 1;

  // bind interface...
  HB626_Open      = (HB626_OPEN)      GetProcAddress(HB626_Handle,"HB626_Open");
  HB626_Close     = (HB626_CLOSE)     GetProcAddress(HB626_Handle,"HB626_Close");
  HB626_Send_Cfg  = (HB626_SEND_CFG)  GetProcAddress(HB626_Handle,"HB626_Send_Cfg");
  HB626_Get_Reply = (HB626_GET_REPLY) GetProcAddress(HB626_Handle,"HB626_Get_Reply");

  atexit (Unload_HB626);

  return 0;
}

